/*------------------------------------------------------------------------------*
 * File Name:ImportWizard.cpp				 									*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	 Jason 12/14/03 v7.5780 ADD_SAVE_FILTERS_PAGE								*
 *	 Jason 12/14/03 v7.5781 ADD_FILE_TYPES_PAGE									*
 *	 Jason 12/14/03 v7.5780 ADD_DRAP_AND_DROP_PAGE								*
 *	 Jason 12/14/03 v7.5781 ADD_FILE_PLOTTING									*
 *   Jacky 12/21/03 v7.5784 ADD_FILE_DATASELECTION                              *
 *   Danice 12/25/03 v7.5788 ADD_SOME_EVENT										*
 *   Danice 12/30/03 v7.5790b TEMP_MOVE_TO_DIALOG								*
 *   Danice 12/31/03 v7.5790 FOR_NEW_DIALOG_CONSTRUCTOR							*
 *   Danice 1/16/04 v8.0800 MOVE_UTILITY_TO_CPP_FILE							*
 *   Danice 1/17/04 v8.0802 UTILITY_EASY_UNDERSTAND								*
 *	 EJP 03-30-2004 v7.5826 QA70-6188 CHECK_FILE_FOR_READING					*
 * EJP 09-10-2004 v8.0132 QA70-5658 IMPROVE_HDRVAR_EXTRACTION					*
 * SY 2007-04-15 QA80-9609 v8.0601 MORE_ON_CHANGE_COL_IN_IMPWIZ					*
 *	AW 04/11/07 QA80-9609 v8.0598 MORE_ON_CHANGE_COL_IN_IMPWIZ					*
 *	Hong 04/27/07 v8.0609 COMMENT_OUT_DEBUG_INFO								*
 *	Hong 03/19/08 QA80-13296-P3 TURN_OFF_AUTO_COL_TYPE_IF_USER_SET_DATE_FMT_BY_HAND_ASKED_CP
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
////////////////////////////////////////////////////////////////////////////////////
#include <Origin.h>

#pragma labtalk(0) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS

#include "IWfirst.h"

///---Sim 01-27-2007 FINISH_EQUAL_OK_BUTTON
//#define IDC_FINISH			0x3025
#define IDC_FINISH			IDOK
///---END FINISH_EQUAL_OK_BUTTON

// Main dialog class
class WizPageDialog : public Dialog
{
public:
	WizPageDialog() : Dialog(IDD_IW, "ImportWiz")
	{
		m_strFilename = "";
		DISABLE_GET_FILTER_ONLY;		///Danice 12/31/03 v7.5790 FOR_NEW_DIALOG_CONSTRUCTOR
	}

	///Danice 12/31/03 v7.5790 FOR_NEW_DIALOG_CONSTRUCTOR
	// new constructor for using dialog from outside to get filter with file name given
	WizPageDialog(LPCSTR lpcszDataFile) : Dialog(IDD_IW, "ImportWiz")
	{
		m_strFilename = lpcszDataFile;
		if(m_strFilename.IsFile())
			ENABLE_GET_FILTER_ONLY;
	}
	///END FOR_NEW_DIALOG_CONSTRUCTOR

	int WizardDoModal(HWND hWnd)
	{
		InitMsgMap();
		return DoModal(hWnd, DLG_TITLE_TO_HAVE_PAGE_NAME);
	}

	// InitMsgMap function setting up event handlers for main Dialog
	EVENTS_BEGIN
		ON_INIT(Init)
		///Danice 12/30/03 v7.5790b TEMP_MOVE_TO_DIALOG
		ON_CANCEL(OnCancel)
		ON_FINISH(OnFinish)
		///END TEMP_MOVE_TO_DIALOG
		ON_DESTROY(OnDestroyDialog)

		///Danice 12/25/03 v7.5788 ADD_SOME_EVENT
		ON_WKSCTRL_EVENT(WKSCTRL_EVENT_TYPE_CHANGE, OnWksCtrlChangeColTypeOrDesignation)
		/// JCG 06/17/03 QA70-4575 v7.0602 FIX_ITEM32 
		ON_WKSCTRL_CHANGE_COL_DESIG(OnWksCtrlChangeColTypeOrDesignation)
		/// end FIX_ITEM32 
		///END ADD_SOME_EVENT
		ON_OBJECT_MODIFY(OnOriginModify)		/// TD 11-8-04 Sample handling of PostMessages From Splitter window
		ON_OBJECT_INFO_MODIFY(OnOriginModify)	/// TD 11-8-04 Sample handling of PostMessages From Splitter window
	EVENTS_END

	
	/// TD 11-8-04 Sample handling of PostMessages From Splitter window
	BOOL OnOriginModify(Worksheet wks, int nKind)
	{
		if(wks)
		{
			string strWksName;
			wks.GetName(strWksName);
			//printf("Worksheet %s modified\n", strWksName); /// Hong 04/27/07 v8.0609 COMMENT_OUT_DEBUG_INFO
		}
		//out_str("OnOriginModify"); /// Hong 04/27/07 v8.0609 COMMENT_OUT_DEBUG_INFO
		return TRUE;
	}
	///-------
	// Event handlers for main Dialog
	BOOL Init()
	{
		m_Sheet.Create(IDC_PAGE_PLACEHOLDER, *this);
		m_Sheet.InitSheet(m_strFilename);
		
		return TRUE;
	}
	///Danice 12/30/03 v7.5790b TEMP_MOVE_TO_DIALOG
	bool OnCancel()
	{
		return m_Sheet.OnClickCancel();
	}
	
	bool OnFinish()
	{
		return m_Sheet.OnClickFinish();
	}
	///END TEMP_MOVE_TO_DIALOG
	
	BOOL OnDestroyDialog()
	{
		return TRUE;
	}
	
	///Danice 12/25/03 v7.5788 ADD_SOME_EVENT
	BOOL OnWksCtrlChangeColTypeOrDesignation(DWORD iCtrlID, LONG iColIndex)
	{
		int iPageID;
		if( IDC_COL_WKS_PREVIEW == iCtrlID )
			iPageID = IDD_AIW_COLUMNS;
		else if( IDC_RANGE_PREVIEW == iCtrlID )
			iPageID = IDD_IW_RANGE;
		else
		/// JCG 06/11/03 QA70-4575 v7.0600 FIX_ITEM32 
		///	return FALSE; // unknown wks ctrl
		if( IDC_BIW_DATAPATERN_PREVIEW_LC == iCtrlID )
			iPageID = IDD_BIW_DATAPATERN;	
		else
		{
			ASSERT(FALSE);
			return FALSE;
		}
		/// end FIX_ITEM32 
		
		
		//Worksheet wks(s_strWks);
		string s_strWks = m_Sheet.GetWksName();
		Worksheet wks(m_Sheet.GetWksName());
		if( !wks )
			return FALSE;

		///Danice 12/25/03 v7.5788 CALL_SHEET_FUNCTION
		//fuSetDesignations(s_trFilter, wks.GetColDesignations());
		//fuSetFormats(s_trFilter, wks.GetColFormats());
		///---Sim 08-14-2006 PREPARE_PARTIAL_FILTER
		//fuSetDesignations(m_Sheet.m_trFilter, wks.GetColDesignations());
		//fuSetFormats(m_Sheet.m_trFilter, wks.GetColFormats());
		TreeNode trFilter = m_Sheet.m_trFilter;
		string strPrePartial = "";
		/// Hong 9/01/06 GET_FILTER_BY_ID
		//if ( trFilter.Common.Partial.nVal )
		//{
			//string strTemp(' ', trFilter.Common.PartialC1.nVal);
		if( fuGetInt(trFilter, IDE_IMP_PARTIAL, 0) )
		{
			string strTemp( ' ', fuGetInt(trFilter, IDE_IMP_PARTIALC1, 0) );
		/// end GET_FILTER_BY_ID
			strPrePartial = strTemp;
		}
		fuSetDesignations(trFilter, strPrePartial + wks.GetColDesignations() ); 
		/// Hong 03/19/08 QA80-13296-P3 TURN_OFF_AUTO_COL_TYPE_IF_USER_SET_DATE_FMT_BY_HAND_ASKED_CP
		//fuSetFormats(trFilter, strPrePartial + wks.GetColFormats() ); 
		string		strNewColFmts = strPrePartial + wks.GetColFormats();
		fuSetFormats(trFilter, strNewColFmts );
		if ( 0 != fuGetInt(trFilter, IDE_ASCIMP_AUTOCOLTYPES, 0) )
		{
			char		ch = '0' + OKCOLTYPE_DATE;
			if ( -1 != strNewColFmts.Find(ch) ) // if have date format specified
			{
				fuSetInt(trFilter, IDE_ASCIMP_AUTOCOLTYPES, 0);
				m_Sheet.m_ascimp.iAutoColTypes = 0;
				m_Sheet.m_binimp.iAutoColTypes = 0;
			}
		}
		/// end TURN_OFF_AUTO_COL_TYPE_IF_USER_SET_DATE_FMT_BY_HAND_ASKED_CP
		///---END PREPARE_PARTIAL_FILTER
		///END CALL_SHEET_FUNCTION
		
		/// EJP 08-19-2003 v7.5667 REIMPORT_AFTER_USER_CHANGE_COL_FORMAT
		///UpdateWksCtrl(iPageID); // do not re-import, just update wks ctrl
		UpdatePreview(iPageID);
		/// end REIMPORT_AFTER_USER_CHANGE_COL_FORMAT
		return TRUE;
	}
	
	void UpdatePreview(int iWizPageID)
	{
		//m_Sheet.UpdateImpStructCommonFromTree();//Hong 9/01/06 COMMON_REMOVE_FROM_STRUCTURE
		m_Sheet.ImportToWks();
		UpdateWksCtrl(iWizPageID);
	}

	void UpdateWksCtrl(int iWizPageID)
	{
		int iCtrlID;
		switch( iWizPageID )
		{
		case IDD_AIW_COLUMNS:
			iCtrlID = IDC_COL_WKS_PREVIEW;
			break;
		case IDD_IW_RANGE:
			iCtrlID = IDC_RANGE_PREVIEW;
			break;
		case IDD_BIW_DATAPATERN:
			iCtrlID = IDC_BIW_DATAPATERN_PREVIEW_LC;
			break;
		default:
			return;
		}
	
		WorksheetControl wc = GetItem(iCtrlID, iWizPageID);
		/// SY 2007-04-15 QA80-9609 v8.0601 MORE_ON_CHANGE_COL_IN_IMPWIZ
		/// AW 04/11/07 QA80-9609 v8.0598 MORE_ON_CHANGE_COL_IN_IMPWIZ
		/*
		int nXScrollPos, nYScrollPos;
		nXScrollPos = wc.GetScrollPos(SB_HORZ);
		nYScrollPos = wc.GetScrollPos(SB_VERT);
		int nMinPosX = 0, nMaxPosX = 0;
		wc.GetScrollRange(SB_HORZ, nMinPosX, nMaxPosX);
		int nMinPosY = 0, nMaxPosY = 0;
		wc.GetScrollRange(SB_VERT, nMinPosY, nMaxPosY);
		*/
		/// END MORE_ON_CHANGE_COL_IN_IMPWIZ
		/// end MORE_ON_CHANGE_COL_IN_IMPWIZ
		wc.Attach(m_Sheet.GetWksName());
		wc.Update();
		/// SY 2007-04-15 QA80-9609 v8.0601 MORE_ON_CHANGE_COL_IN_IMPWIZ
		/// AW 04/11/07 QA80-9609 v8.0598 MORE_ON_CHANGE_COL_IN_IMPWIZ
		/*
		wc.SetScrollRange(SB_HORZ, nMinPosX, nMaxPosX);
		wc.SetScrollRange(SB_VERT, nMinPosY, nMaxPosY);
		wc.SetScrollPos(SB_HORZ, nXScrollPos);
		wc.SetScrollPos(SB_VERT, nYScrollPos);
		*/
		/// END MORE_ON_CHANGE_COL_IN_IMPWIZ
		/// end MORE_ON_CHANGE_COL_IN_IMPWIZ
	}
	///END ADD_SOME_EVENT
	
	// Data member of main Dialog is PropertySheet (place holder)
	ImpWizSheet m_Sheet;
	
	string		m_strFilename ;
};

		
///---Sim 01-04-2007 SUPPORT_OPEN_IMPORT_WIZARD_WHEN_DRAG_AND_DROP
void ImportWizardWithFileName(LPCSTR lpcszDataFile)
{
	WizPageDialog wdlg(lpcszDataFile);
	wdlg.WizardDoModal(GetWindow());
}
///---END SUPPORT_OPEN_IMPORT_WIZARD_WHEN_DRAG_AND_DROP
		
//CPY 12/30/03, added this to allow linking
// this should use a WizPageDialog constructor that has a filename to indicate
// that the wizard is open with the purpose to retrive the filter, so when
// constructor has filename, then no need to open Source page and no need to
// do actual import, just add a function to GetTree and then return the trFilter
// back to caller
bool iwGetFilter(LPCSTR lpcszDataFile, string &strFilterFile, TreeNode &trFilter)
{
	///Danice 12/31/03 v7.5790 FOR_NEW_DIALOG_CONSTRUCTOR
	/*
	IW_Init(lpcszDataFile);
	ENABLE_GET_FILTER_ONLY;
	int iRet = ImportWizDlg.DoModal(GetWindow());
	DISABLE_GET_FILTER_ONLY;
	if( IS_CLICKED_FINISH )
	{
		trFilter = s_trFilter;
		strFilterFile = s_strFilterFileSaved;
		return true;
	}
	return false;
	*/
	WizPageDialog wdlg(lpcszDataFile);
	int iRet = wdlg.WizardDoModal(GetWindow());
	if(IDC_FINISH == iRet)
	{
		trFilter = wdlg.m_Sheet.m_trFilter;
		strFilterFile = wdlg.m_Sheet.GetstrFilterFileSaved();
		return true;
	}
	return false;
	///END FOR_NEW_DIALOG_CONSTRUCTOR
}

#pragma labtalk(2) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS
void ImportWizard()
{
	WizPageDialog wdlg();
	wdlg.WizardDoModal(GetWindow());
}
